<?php
include 'config.php';

$message = '';
$message_type = 'error';
$token_valid = false;
$token = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $token = $_POST['token'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($token) || empty($password) || empty($confirm_password)) {
        $message = 'Please fill all fields.';
        $token_valid = true; 
    } elseif (strlen($password) < 6) {
        $message = 'Password must be at least 6 characters long.';
        $token_valid = true;
    } elseif ($password !== $confirm_password) {
        $message = 'Passwords do not match.';
        $token_valid = true; 
    } else {
        
        $stmt = $conn->prepare("UPDATE users SET password = ?, rs_auth_token = NULL, token_expired = NULL WHERE rs_auth_token = ?");
        $stmt->bind_param("ss", $password, $token);
        
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            $message = 'Password Updated Successfully!';
            $message_type = 'success';
            $token_valid = false;
        } else {
            $message = 'Failed to update password. This link may have already been used.';
            $token_valid = false;
        }
        $stmt->close();
    }

} elseif (isset($_GET['rs_auth']) && !empty(trim($_GET['rs_auth']))) {
    $token = trim($_GET['rs_auth']);
    
    $stmt = $conn->prepare("SELECT id, token_expired FROM users WHERE rs_auth_token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $expiry_time = strtotime($row['token_expired']);
        
        $now_result = $conn->query("SELECT NOW() as mysql_now");
        $current_time = strtotime($now_result->fetch_assoc()['mysql_now']);
        $now_result->free_result();

        if ($current_time > $expiry_time) {
            $message = 'Forget Session Expired. Please request a new password reset link.';
        } else {
            $token_valid = true;
        }
    } else {
        $message = 'Invalid or Expired Token. Please check your link or try again.';
    }
    $stmt->close();

} else {
    $message = 'No token provided. Invalid access.';
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-R8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Set New Password</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #0d051c;
            background-image:
                linear-gradient(rgba(118, 7, 133, 0.1) 1px, transparent 1px),
                linear-gradient(90deg, rgba(118, 7, 133, 0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: bg-pan 20s linear infinite;
        }

        @keyframes bg-pan {
            0% { background-position: 0% 0%; }
            100% { background-position: 100% 100%; }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .form-card {
            background: rgba(10, 5, 20, 0.6);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(167, 139, 250, 0.2);
            box-shadow: 0 10px 50px rgba(59, 130, 246, 0.1), 0 0 30px rgba(167, 139, 250, 0.1);
            animation: fadeInUp 0.8s ease-out forwards;
        }

        .input-field {
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(167, 139, 250, 0.3);
            transition: all 0.3s ease;
        }
        .input-field:focus {
            background-color: rgba(255, 255, 255, 0.1);
            border-color: #A78BFA;
            box-shadow: 0 0 20px rgba(167, 139, 250, 0.4);
        }

        .submit-btn {
            background: linear-gradient(90deg, #8E2DE2, #4A00E0, #8E2DE2);
            background-size: 200% auto;
            transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
            box-shadow: 0 4px 20px rgba(142, 45, 226, 0.3);
        }
        .submit-btn:hover {
            background-position: right center;
            transform: translateY(-3px);
            box-shadow: 0 8px 35px rgba(142, 45, 226, 0.6);
        }
        
        .message-box {
            animation: fadeInUp 0.5s ease-out;
            background-color: rgba(10, 5, 20, 0.8);
            border: 1px solid rgba(167, 139, 250, 0.2);
            box-shadow: 0 4px 20px rgba(167, 139, 250, 0.1);
        }
        .message-error {
            color: #F87171;
        }
        .message-success {
            color: #34D399;
        }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4 text-gray-200 overflow-hidden">

    <div class="w-full max-w-md">
        <div class="form-card rounded-2xl p-8 shadow-2xl">
            
            <div class="text-center mb-8">
                <svg class="w-16 h-16 mx-auto text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                <h1 class="text-3xl font-bold text-white mt-4">Set New Password</h1>
                
                <?php if ($token_valid) : ?>
                    <p class="text-gray-400 mt-2">Enter your new password below.</p>
                <?php endif; ?>
            </div>

            <?php if ($token_valid) : ?>
                
                <form action="rs_change_pass.php" method="POST" class="space-y-6">
                    <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                    
                    <?php if (!empty($message)) : ?>
                        <div class="message-box message-error p-4 rounded-lg text-center text-sm">
                            <?php echo $message; ?>
                        </div>
                    <?php endif; ?>

                    <div>
                        <label for="password" class="block text-sm font-medium text-purple-300 mb-2">New Password</label>
                        <input type="password" name="password" id="password" class="input-field w-full px-4 py-3 rounded-lg text-white placeholder-gray-500 focus:outline-none" placeholder="••••••••" required>
                    </div>
                    
                    <div>
                        <label for="confirm_password" class="block text-sm font-medium text-purple-300 mb-2">Confirm New Password</label>
                        <input type="password" name="confirm_password" id="confirm_password" class="input-field w-full px-4 py-3 rounded-lg text-white placeholder-gray-500 focus:outline-none" placeholder="••••••••" required>
                    </div>
                    
                    <button type="submit" class="submit-btn w-full text-white font-bold py-3 px-4 rounded-lg focus:outline-none">
                        Update Password
                    </button>
                </form>

            <?php else : ?>
                
                <div class="message-box <?php echo ($message_type == 'success') ? 'message-success' : 'message-error'; ?> p-6 rounded-lg text-center">
                    <p class="text-lg font-medium"><?php echo $message; ?></p>
                </div>

            <?php endif; ?>

        </div>
    </div>

</body>
</html>