<?php
header('Content-Type: application/json');
require 'Rs Mail Libs/PHPMailerAutoload.php';

function sendPasswordResetEmail($appName, $fromEmail, $password, $recipient, $resetUrl) {
    try {
        $mail = new PHPMailer(true);
        $mail->IsSMTP();
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = 'tls';
        $mail->Host = 'smtp.gmail.com';
        $mail->Port = 587;
        $mail->IsHTML(true);
        $mail->CharSet = 'UTF-8';
        $mail->Username = $fromEmail;
        $mail->Password = $password;
        $mail->SetFrom($fromEmail, $appName);
        $mail->Subject = 'Password Reset Request for ' . $appName;

        $htmlBody = "
            <!DOCTYPE html>
            <html lang='en'>
            <head>
                <meta charset='UTF-8'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>Password Reset Request</title>
                <style>
                    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@700&family=Poppins:wght@400;600&display=swap');
                </style>
            </head>
            <body style='margin: 0; padding: 20px; background-color: #100a1f; font-family: \"Poppins\", sans-serif; background-image: radial-gradient(circle at top, rgba(120, 36, 219, 0.5) 0%, transparent 40%);'>
                <div style='max-width: 580px; margin: auto; background: linear-gradient(145deg, rgba(20, 15, 35, 0.7), rgba(10, 5, 20, 0.7)); border-radius: 20px; border: 1px solid rgba(255, 100, 200, 0.2); box-shadow: 0 16px 40px rgba(255, 61, 139, 0.1); backdrop-filter: blur(15px); -webkit-backdrop-filter: blur(15px);'>
                    <div style='padding: 40px; text-align: center; color: #e0e0e0;'>
                        <h1 style='font-family: \"Orbitron\", sans-serif; font-size: 34px; font-weight: 700; margin: 0 0 15px; color: #fff; text-shadow: 0 0 5px #fff, 0 0 15px #ff69b4, 0 0 30px #ff69b4, 0 0 50px #ff69b4;'>
                           {$appName}
                        </h1>
                        <h2 style='font-size: 24px; font-weight: 600; margin: 0 0 15px; color: #f0f0f0;'>
                            Reset Your Password
                        </h2>
                        <p style='font-size: 16px; color: #c0c0c0; margin: 0 0 35px; line-height: 1.7;'>
                            Click the button below to reset your password.
                            <br><span style='font-size: 14px; color: #999;'>This link will expire in 10 minutes.</span>
                        </p>
                        
                        <div style='margin: 35px 0;'>
                            <a href='{$resetUrl}' target='_blank' style='display: inline-block; padding: 18px 35px; font-family: \"Orbitron\", sans-serif; font-size: 18px; font-weight: 700; color: #ffffff; text-decoration: none; border-radius: 12px; background: linear-gradient(135deg, #ff69b4, #8a2be2); box-shadow: 0 0 25px rgba(255, 105, 180, 0.4), 0 4px 15px rgba(0,0,0,0.2); text-shadow: 0 0 8px rgba(255, 255, 255, 0.9); transition: all 0.3s ease;'>
                                Reset Your Password
                            </a>
                        </div>

                        <div style='border-top: 1px solid rgba(255, 100, 200, 0.2); margin: 40px auto 0; width: 80%;'></div>
                        <p style='font-size: 14px; color: #888; margin: 30px 0 0; line-height: 1.6;'>
                            For your security, please do not share this link with anyone. If you did not request this, you can safely disregard this email—your account remains secure.
                        </p>
                    </div>
                </div>
            </body>
            </html>
        ";

        $mail->Body = $htmlBody;
        $mail->AddAddress($recipient);

        if (!$mail->Send()) {
            throw new Exception('Email could not be sent. Mailer Error: ' . $mail->ErrorInfo);
        }

        return json_encode([
            'status' => 'success',
            'message' => 'Password reset link sent successfully!'
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        return json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
}

$required_params = ['app_name', 'from_email', 'password', 'to_email', 'reset_url'];
$missing_params = [];

foreach ($required_params as $param) {
    if (!isset($_GET[$param]) || empty(trim($_GET[$param]))) {
        $missing_params[] = $param;
    }
}

if (!empty($missing_params)) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required parameters: ' . implode(', ', $missing_params)
    ]);
    die();
}

$appName = htmlspecialchars($_GET['app_name']);
$fromEmail = filter_var($_GET['from_email'], FILTER_SANITIZE_EMAIL);
$password = $_GET['password'];
$recipient = filter_var($_GET['to_email'], FILTER_SANITIZE_EMAIL);
$resetUrl = filter_var($_GET['reset_url'], FILTER_SANITIZE_URL);

if (!filter_var($fromEmail, FILTER_VALIDATE_EMAIL) || !filter_var($recipient, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid email format provided.'
    ]);
} elseif (!filter_var($resetUrl, FILTER_VALIDATE_URL)) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid URL format provided.'
    ]);
} else {
    echo sendPasswordResetEmail($appName, $fromEmail, $password, $recipient, $resetUrl);
}
?>